package elaborator.tests;

import elaborator.AdapterExportDatabase;
import elaborator.Elaborator;
import elaborator.Searcher;
import elaborator.Sender;
import elaborator.utils.FileLoader;

public class Test3 {
	public static void main(String[] args) {

		TestPlanetDatabase virtualdatabase = new TestPlanetDatabase();
		Elaborator elaborator = new Elaborator();
		Sender sender = new AdapterExportDatabase(virtualdatabase);
		elaborator.setSender(sender);
		
		elaborator.setReceiver(new FileLoader("Urano"));
		elaborator.receiveData();
		elaborator.sendData();
		sender.writeDatabase();
		
		elaborator.setReceiver(new FileLoader("Saturno"));
		elaborator.receiveData();
		elaborator.sendData();
		sender.writeDatabase();
		
		elaborator.setReceiver(new FileLoader("NonAffine"));
		elaborator.receiveData();
		elaborator.sendData();
		sender.writeDatabase();
		
		System.out.println("\nPianeti salvati nel DB");
		
		Searcher searcher=new Searcher(virtualdatabase);
		searcher.searchPlanetAffinity("Urano");
		
		
		
	}
}
